/**
* INTEL CONFIDENTIAL
* Copyright 2013-2014 Intel Corporation All Rights Reserved.

* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its suppliers
* and licensors. The Material may contain trade secrets and proprietary and confidential
* information of Intel Corporation and its suppliers and licensors, and is protected
* by worldwide copyright and trade secret laws and treaty provisions. No part of
* the Material may be used, copied, reproduced, modified, published, uploaded, posted,
* transmitted, distributed, or disclosed in any way without Intel's prior express
* written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual property
* right is granted to or conferred upon you by disclosure or delivery of the Materials,
* either expressly, by implication, inducement, estoppel or otherwise. Any license under
* such intellectual property rights must be express and approved by Intel in writing.
*
* Unless otherwise agreed by Intel in writing, you may not remove or alter this notice
* or any other notice embedded in Materials by Intel or Intel's suppliers or licensors in any way.
*/

#ifndef I2CPUBLIC_H
#define I2CPUBLIC_H

#pragma once
/* Define an Interface Guid so that app can find the device and talk to it. */
/* {4FD00181-F807-41AA-8D33-F22C5D7CAEBD} */
DEFINE_GUID(I2C_LPSS_INTERFACE_GUID, 
    0x4fd00181, 0xf807, 0x41aa, 0x8d, 0x33, 0xf2, 0x2c, 0x5d, 0x7c, 0xae, 0xbd);


/* Device type           -- in the "User Defined" range." */

#define FILE_DEVICE_I2C_CONTROLLER 0x8001

/* The IOCTL function codes from 0x800 to 0xFFF are for customer use. */

#define IOCTL_I2C_EXECUTE_WRITE     \
        CTL_CODE(FILE_DEVICE_I2C_CONTROLLER, 0x910, METHOD_DIRECT_TO_HARDWARE, FILE_ANY_ACCESS)
#define IOCTL_I2C_EXECUTE_READ      \
        CTL_CODE(FILE_DEVICE_I2C_CONTROLLER, 0x911, METHOD_DIRECT_FROM_HARDWARE, FILE_ANY_ACCESS)
#define IOCTL_I2C_EXECUTE_SEQUENCE  \
        CTL_CODE(FILE_DEVICE_I2C_CONTROLLER, 0x912, METHOD_DIRECT_FROM_HARDWARE, FILE_ANY_ACCESS)

/*
* Transfer direction read/write
*/
typedef enum I2C_TRANSFER_DIRECTION
{
    SpbTransferDirectionNone,
    SpbTransferDirectionFromDevice,
    SpbTransferDirectionToDevice,
    SpbTransferDirectionMax
}I2C_TRANSFER_DIRECTION;

/*
* I2C transfer speed setting
*/
typedef enum _I2C_BUS_SPEED
{
    I2C_BUS_SPEED_100KHZ    = 1,
    I2C_BUS_SPEED_400KHZ    = 2,
    I2C_BUS_SPEED_1000KHZ   = 3,
    I2C_BUS_SPEED_3400KHZ   = 4,
    I2C_BUS_SPEED_1700KHZ   = 5
}I2C_BUS_SPEED;

/*
* I2C address mode setting
*/
typedef enum _I2C_ADDRESS_MODE
{
    AddressMode7Bit     = 1,
    AddressMode10Bit    = 2
} I2C_ADDRESS_MODE;

__pragma(pack(push,4))
typedef struct _I2C_SINGLE_TRANSMISSION
{
    UINT8       AddressMode;
    UINT16      Address;
    UINT8       BusSpeed;
    UINT32      DataLength; 
    PVOID       pBuffer;
    PVOID       pReserve;   /* only used in Driver, user don't need to fill*/
    UINT64      Reserve;
}I2C_SINGLE_TRANSMISSION, *PI2C_SINGLE_TRANSMISSION;

typedef struct _I2C_SEQUENCE_TRANSMISSION
{
    UINT8       AddressMode;
    UINT16      Address;
    UINT8       BusSpeed;
    UINT8       Direction;
    UINT32      DelayInUs;
    UINT32      DataLength;
    PVOID       pBuffer;
    PVOID       pReserve;   /* only used in Driver, user don't need to fill*/
    UINT64      Reserve;
}I2C_SEQUENCE_TRANSMISSION, *PI2C_SEQUENCE_TRANSMISSION;

__pragma(pack(pop))

#define I2C_SEQUENCE_TRANSMISSION_ENTRY(_COUNT_)    \
__pragma(pack(push,4))                              \
struct {                                            \
    UINT64                      Size;               \
    I2C_SEQUENCE_TRANSMISSION   List[(_COUNT_)];    \
}                                                   \
__pragma(pack(pop))

#define I2C_SEQUENCE_ITEM_INIT(_Item_,_AddressMode_,_Address_,_Speed_,_Direction_,_DelayInUs_,_DataLength_,_pBuffer_)               \
    (_Item_).AddressMode    = (UINT8)(_AddressMode_);   \
    (_Item_).Address        = (UINT16)(_Address_);      \
    (_Item_).BusSpeed       = (UINT8)(_Speed_);         \
    (_Item_).Direction      = (UINT8)(_Direction_);     \
    (_Item_).DelayInUs      = (UINT32)(_DelayInUs_);    \
    (_Item_).DataLength     = (UINT32)(_DataLength_);   \
    (_Item_).pBuffer        = (PVOID)(_pBuffer_);

#endif